/************************************************************************************************
 *   深圳市摩西尔电子有限公司 @版本所有@
 *
 *   此文件用于重新计算箱体
 *
 * 修改:
 *      类型 : 创建
 *      作者 : 李智明
 *      时间 : 2021.09.23
 *      内容 : 所有代码
 *************************************************************************************************/

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    处理大屏界面位置指令
 * 参数:
 *    @param { Promise<string> } str 大屏位置指令
 * 返回:
 *    @returns  { Promise<string> } str_data 解析后的大屏指令
 * 例子:
 *    NA
 * 备注:
 *    NA
 * 修改:
 *    1. 类型 : 创建
 *       作者 : 李智明
 *       时间 : 2021-09-23
 *       内容 : 所有代码
************************************************************************************************/
function mc_deal_screen_order(str) {
    var str_data = str.replace(/[a-zA-Z]/g, "");
    var arr_data = [];
    var arr_hub_data = [];

    if (str_data.includes("_")) {
        arr_data = str_data.split("_");
        arr_hub_data = arr_data[2].split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":" + (Number(arr_hub_data[0]) - 1) + ":" + (Number(arr_hub_data[1]) - 1);
    } else {
        arr_data = str_data.split(":");
        str_data = (Number(arr_data[0]) - 1) + ":" + (Number(arr_data[1]) - 1) + ":-1:-1";
    }

    return str_data;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取发送卡端口 获取发送卡每个端口的备份状态
 * 参数:
 *    @param {Promise<function>} fun_callback     回调

 * 返回：
 *    NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.07.13
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_send_p_backup_status(fun_callback) {
    if ("function" !== typeof fun_callback) {
        fun_callback("");
        return;
    }
    var arr_s_p = [];

    // 请求对象
    var obj_req_s_p = new mc_sdk_param();

    obj_req_s_p.set_param_clear();
    obj_req_s_p.set_func("HW_SENDCARD_CONNECT");
    obj_req_s_p.set_cmd("GET_PARAM");

    $.post("/access_shell", obj_req_s_p.get_json(), function (result, status) {
        var obj_res_s_p = new mc_sdk_param();

        obj_res_s_p.set_param_clear();
        obj_res_s_p.set_json(result);

        var ui_param_cnt = obj_res_s_p.get_param_cnt();

        for (var idx = 0; idx < ui_param_cnt; idx++) {
            var str_param_name = obj_res_s_p.get_param_name(idx);

            if ("ERROR_CODE" === str_param_name) {
                continue;
            }
            var str_param_val = obj_res_s_p.get_param_value(str_param_name);
            var str_cnt = str_param_val.split(":")[1];

            arr_s_p.push(str_cnt);
        }

        // var str_s_id = mc_get_top_data("g_obj_sendcard_data").get_current_sendcard_param() + "";
        var ui_s_cnt = arr_s_p.length;
        var obj_req = new mc_sdk_param();

        obj_req.set_param_clear();
        obj_req.set_cmd("GET_PARAM");
        obj_req.set_func("HW_SENDCARD_OUTPORT_BACKUP");

        for (var idx_s = 0; idx_s < ui_s_cnt; idx_s++) {
            var ui_s_p_cnt = Number(arr_s_p[idx_s]);

            for (var id = 0; id < ui_s_p_cnt; id++) {
                var str_data = "(" + idx_s + ":" + id + ")";

                obj_req.set_param_value(str_data, "");
            }
        }


        $.post("/access_shell", obj_req.get_json(), function (backup_result, status) {
            var obj_return = {

            };
            var obj_res = new mc_sdk_param();

            obj_res.set_param_clear();
            obj_res.set_json(backup_result);
            var ui_par_cnt = obj_res.get_param_cnt();

            for (var key = 0; key < ui_par_cnt; key++) {
                var str_par_name = obj_res.get_param_name(key);

                if ("ERROR_CODE" === str_par_name) {
                    continue;
                }
                var str_par_val = obj_res.get_param_value(str_par_name);

                str_par_name = str_par_name.slice(1, -1);

                if (parent.G_B_BACKUP_PORT_SEND) {
                    // 发备口
                    if ("0" === str_par_val) {
                        obj_return[str_par_name] = true;
                    }
                } else {
                    // 发主口
                    if ("1" === str_par_val || !str_par_val) {
                        obj_return[str_par_name] = true;
                    }
                }
            }
            fun_callback(obj_return);
            return;
        });
        return;
    });
    return;
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    获取箱体参数 用于下发base
 * 参数:
 *    @param {Promise<object>} obj_same_hub_queue     界面dom数据
 *    @param {Promise<string>} card_order     位置指令
 *    @param {Promise<object>} obj_backup     备份

 * 返回：
 *    @return {Promise<Array>} []     数据


 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_box_config_data_for_congulate(obj_same_hub_queue, card_order, obj_backup) {
    if ("[OBJECT OBJECT]" !== Object.prototype.toString.call(obj_same_hub_queue).toUpperCase()) {
        return [];
    }

    var arr_key = Object.keys(obj_same_hub_queue);
    // 硬件连接状态false时 HUB HUBPORT 索引置零
    var b_hardware_state = mc_get_top_data("B_HARDWARE_STATE");
    // 记录各卡出现次数
    var obj_card_cnt = {
        b_port: true,
        port: {},
        // "0:0":cnt
        hub_cnt: {},
        // "0:0:0":cnt
        hubport_cnt: {}
    };
    // 箱体宽高 {box_name:[w,h],,,} 避免重复获取
    var obj_box_size = {};
    var ARY_BOX_DATA = mc_get_top_data("ARY_BOX_DATA");
    var ARY_MOD_DATA = mc_get_top_data("ARY_MOD_DATA");
    // 整合数据{KEY:{idx:'',data:{}}} 每项为一组群发数据
    var obj_integration_data = {};
    // 整合之前长度
    var ui_intergration_before_len = 0;

    for (var i_key = 0; i_key < arr_key.length; i_key++) {
        var str_key = arr_key[i_key];
        var arr_line_data = obj_same_hub_queue[str_key];

        if (!str_key || "" === str_key || "?" === str_key || "[OBJECT ARRAY]" !== Object.prototype.toString.call(arr_line_data).toUpperCase() || 0 === arr_line_data.length) {
            continue;
        }
        var obj_param = mc_card_param_handle(str_key, b_hardware_state);
        var str_param = obj_param.str_param;
        var str_sendport = obj_param.str_sendport;

        add_data(obj_card_cnt.port, str_sendport.substr(0, str_sendport.lastIndexOf(":")));
        add_data(obj_card_cnt.hub_cnt, str_sendport);
        add_data(obj_card_cnt.hubport_cnt, str_param.substr(0, str_param.lastIndexOf(":")));

        // 筛选符合卡列表下标、符合备份信息卡  || !obj_backup[str_sendport]
        if (!mc_filter_data_is_eligible(card_order, str_key)) {
            obj_card_cnt.b_port = false;
            continue;
        }
        var b_group_recv = true;
        var str_intergration_key = "";
        var ui_recv_len = arr_line_data.length;

        for (var i_recv = 0; i_recv < ui_recv_len; i_recv++) {
            var obj_jq = arr_line_data[i_recv];

            // 数据有误 || 过滤新建卡 || 筛选芯片类型和接收卡下标
            if (!obj_jq || "mc_new_box" === obj_jq.attr("mod_id")) {
                b_group_recv = false;
                continue;
            }
            // 整合卡数据
            str_intergration_key = mc_sendbox_handle_compose_data(obj_jq[0], obj_box_size, ARY_BOX_DATA, ARY_MOD_DATA, obj_integration_data, str_param, i_recv);
        }
        // 此连线下卡全部通过筛选且整合之后数据长度若加1 -> 接收卡群发 -> 更改接收卡标识为-1
        var ui_intergration_after_len = Object.keys(obj_integration_data).length;

        if (b_group_recv && ui_intergration_after_len - 1 === ui_intergration_before_len && obj_integration_data[str_intergration_key]) {
            obj_integration_data[str_intergration_key].idx = str_param + ":-1";
        }
        ui_intergration_before_len = ui_intergration_after_len;
    }
    mc_update_group_param(obj_integration_data, obj_card_cnt);
    arr_key = Object.keys(obj_integration_data);
    var arr_result = [];

    // 去除被整合项
    for (var index = 0; index < arr_key.length; index++) {
        var obj_data = obj_integration_data[arr_key[index]];

        if (obj_data) {
            if (-1 === obj_data.idx.indexOf("(")) {
                obj_data.idx = "(" + obj_data.idx + ")";
            }
            arr_result.push(obj_data);
        }
    }
    return arr_result;

    // 添加对象数据 对象，key
    function add_data(o_data, str_keys) {
        if (o_data[str_keys]) {
            o_data[str_keys] += 1;
        } else {
            o_data[str_keys] = 1;
        }
        return;
    }
}


/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据箱体获取对应箱体参数
 * 参数:
 *    @param {Promise<Array>} arr_box_data     界面dom数据
 *    @param {Promise<function>} fun_callback     回调函数

 * 返回：
 *    @return {Promise<object>}  obj_return    数据


 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.23
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_get_box_param(arr_box_data, fun_callback) {
    var ui_len = arr_box_data.length;
    var obj_box_json = {};

    console.log(arr_box_data);

    if (0 === ui_len) {
        fun_callback(false);
        return;
    }
    var arr_box = [];

    // 排除可能存在相同箱体
    for (var id = 0; id < ui_len; id++) {
        var str_curr_box_name = arr_box_data[id].data.str_box_name;

        if (-1 !== arr_box.indexOf(str_curr_box_name)) {
            // 存在
            continue;
        } else {
            arr_box.push(str_curr_box_name);
        }
    }

    var ui_len_send = arr_box.length;
    var idx = 0;

    mc_get_box_base();

    function mc_get_box_base() {
        mc_sdk_get_box_base(arr_box[idx], function (str_req) {
            var obj_req = new mc_sdk_param();

            obj_req.set_json(str_req);
            obj_req.set_json(obj_req.get_param_value(arr_box[idx]));
            obj_box_json[arr_box[idx]] = obj_req;

            idx += 1;
            if (idx === ui_len_send) {
                fun_callback(obj_box_json);
                return;
            }
            mc_get_box_base();
            return;
        });
        return;
    }
}

/************************************************************************************************
 * 类型:
 *    函数
 * 功能:
 *    根据箱体获取对应箱体参数
 * 参数:
 *    @param {Promise<object>} obj_box_json     界面dom数据
 *    @param {Promise<Array>} ARY_BOX_DATA     箱体参数

 * 返回：
 *      NA

 * 修改:
 *   1. 类型 : 创建
 *      作者 : 李智明
 *      时 间 : 2021.09.24
 *      内容 : 所有代码
 ************************************************************************************************/
function mc_modify_device(obj_box_json, ARY_BOX_DATA) {
    var ui_box = ARY_BOX_DATA.length;

    for (var id = 0; id < ui_box; id++) {
        var str_box_name = ARY_BOX_DATA[id].name;

        if (-1 === Object.keys(obj_box_json).indexOf(str_box_name)) {
            continue;
        }

        ARY_BOX_DATA[id].data.mc_util_set_device_data(obj_box_json[str_box_name]);
    }
}
